﻿<%@ Control Language="vb" AutoEventWireup="false" CodeBehind="cu-seleccionrecurso.ascx.vb" Inherits="Web.cu_seleccionrecurso" %>

<asp:UpdatePanel runat="server" Id="UpdatePanelSeleccionRecurso" UpdateMode="Conditional" ChildrenAsTriggers="true">
<ContentTemplate>

<!--Panel que contiene el modal de selección de recurso -->
<asp:Panel ID="PanelSeleccionRecurso" runat="server" CssClass="absolute-popup js-active-popup" Visible="false">

	<div class="popup-inner">
		<div class="popup-content">
			<div class="option-info-block">
				<div class="info-header">
					<div class="option-name">
						<dl class="dl-horizontal">
							<dt><%= Translator.Translate("TRACE_RESOURCE_SELECTION_PANEL_SELECTED_OPTION")%></dt>
							<dd><%=Me.hdnCodeOption.Value %></dd>
						</dl>
					</div>
					<div class="option-buttons">
						<a href="#" class="btn btn-inline" style="display:none;"><%= Translator.Translate("TRACE_RESOURCE_SELECTION_PANEL_MORE_INFO")%></a>
                        <asp:LinkButton ID="btnRefresh" runat="server" CssClass="btn btn-inline btn-icon"><i class="icon2-refresh"></i></asp:LinkButton>
					</div>
				</div>
				<div class="info-filter">
					<p><%= Translator.Translate("TRACE_RESOURCE_SELECTION_PANEL_SELECT_WORKPLACE")%></p>
					<div class="filter-select">
						<label for="option_filter_select"><%= Translator.Translate("TRACE_RESOURCE_SELECTION_PANEL_WORKPLACE")%></label>
                        <asp:DropDownList ID="ddlWorkPlace" name="select1" runat="server" CssClass="form-item blue gray" AutoPostBack="true" Width="190px" style="float:right;"></asp:DropDownList>
					</div>
				</div>
				<div class="info-table">
					<div class="table-box js-table-head table-body">
						<div class="table-container jcf-scrollable">
							<table class="default-table bordered-table">
								<thead>
									<tr>
										<th><%= Translator.Translate("TRACE_RESOURCE_SELECTION_PANEL_STATION")%></th>
										<th><%= Translator.Translate("TRACE_RESOURCE_SELECTION_PANEL_REQUIRED_TOOL")%><strong><%=UCase(Trim(Me.hdnRequiredTool.Value))%></strong></th>
										<th><%= Translator.Translate("TRACE_RESOURCE_SELECTION_PANEL_PORT")%></th>
									</tr>
								</thead>
                                <asp:Repeater ID="repeater_RecursosPuesto" runat="server"  OnItemCommand="repeater_RecursosPuesto_ItemCommand">
                                    <HeaderTemplate>
                                    <tbody>
                                    </HeaderTemplate>
                                    <ItemTemplate>
                                        <tr style="background-color:#fff;">
                                            <td style="font-size:14px;" class="inlinedisplay"><%# IIf(Trim(Eval("InternalReference").ToString())="",Eval("UUID"),Eval("InternalReference"))%></td>
                                            <td><strong><%# Eval("ConnectedTool")%></strong> <i class='<%# IIf(UCase(Eval("ConnectedTool")) = UCase(Trim(Me.hdnRequiredTool.Value)) or Trim(Me.hdnRequiredTool.Value)="", "icon2-check success","icon2-close-rounded error")%>'></i></td>
										    <td><asp:LinkButton ID="BtnSeleccionPuerto" runat="server" CssClass='<%# IIf(Eval("Active")=False,"link-underline inactive",IIf(Eval("Busy")=True and UCase(Eval("CodeUser")) <> UCase(Trim(Me.hdnCodigoUsuario.Value)), "link-underline busy","link-underline success"))%>' CommandName="SELECCIONPUERTO" Enabled='<%# IIf(Eval("Busy") and UCase(Eval("CodeUser")) <> UCase(Trim(Me.hdnCodigoUsuario.Value)) Or Not Eval("Active"), False, True)%>' CommandArgument='<%# Eval("CodeServer") & "#" & Eval("UUID") & "#" & Eval("Port") & "#" &  Eval("Busy")%>'><%= Translator.Translate("TRACE_RESOURCE_SELECTION_PANEL_PORT")%> <%# Eval("Port")%></asp:LinkButton></td>
                                        </tr>
                                    </ItemTemplate>
                                    <FooterTemplate>
                                    </tbody>
                                    </FooterTemplate>
                                </asp:Repeater>
							</table>
						</div>
					</div>
				</div>
				<div class="popup-button">
                    <asp:LinkButton ID="btnCerrar" runat="server" CssClass="btn btn-inline"><%= Translator.Translate("TRACE_RESOURCE_SELECTION_PANEL_CLOSE")%></asp:LinkButton>
				</div>
			</div>
		</div>
		<a href="#" class="popup-opener icon-close js-btn-close"></a>
	</div>

    <!-- controles ocultos -->
    <asp:HiddenField ID="hdnCodeOption" runat="server" Value="" />
    <asp:HiddenField ID="hdnCodigoUsuario" runat="server" Value="" />
    <asp:HiddenField ID="hdnRequiredTool" runat="server" Value="" />

</asp:Panel>

</ContentTemplate>
</asp:UpdatePanel>
   
<ajaxToolkit:UpdatePanelAnimationExtender ID="UpdatePanelSeleccionRecursoExtender" BehaviorID="animation" runat="server" TargetControlID="UpdatePanelSeleccionRecurso">
<Animations>
<OnUpdated>  
    <ScriptAction Script="initRefreshFunctions($('div.absolute-popup'));" />
</OnUpdated>
</Animations>
</ajaxToolkit:UpdatePanelAnimationExtender>

<asp:UpdateProgress ID="UpdateProgressSeleccionRecurso" runat="server" AssociatedUpdatePanelID="UpdatePanelSeleccionRecurso" DisplayAfter="100">
    <ProgressTemplate>
        <asp:Image ID="img_ajax_loading_MenuStation" runat="server" ImageUrl="~/images/ajax-loading.gif" CssClass="ajax_loading_centered"  />
    </ProgressTemplate>
</asp:UpdateProgress>





